local function LoadSound(file)
	local path = THEME:GetPathS("", file);
	return LoadActor(path)
end

local oldidxsteps = -1
local oldidxstyle = -1
local oldidxsong = 0
--local prevsong = GAMESTATE:GetCurrentSong()

local AllSongs = SONGMAN:GetAllSongs()
local SongTitles = {"_"}

for i=1,#AllSongs do
	SongTitles[#SongTitles+1] = tostring(AllSongs[i])
end

--faltaban sonidos para el options list :P
return Def.ActorFrame {
	LoadSound("2-1")..{
		OptionsListResetMessageCommand=cmd(play);
		OptionsListStartMessageCommand=cmd(play);
	};
	LoadSound("3-2")..{
		SelectMenuOpenedMessageCommand=cmd(play);
		OptionsListClosedMessageCommand=cmd(play);
		OptionsMenuChangedMessageCommand=cmd(play);
		PlayerJoinedMessageCommand=cmd(play);
	};
	LoadSound("10-2")..{
		OptionsListLeftMessageCommand=cmd(play);
		OptionsListRightMessageCommand=cmd(play);
	};
	LoadSound("13-1")..{
		OptionsListQuickChangeMessageCommand=cmd(play);
		PlayerJoinedMessageCommand=cmd(play);
	};
	Def.Actor {
		--Text="debug";
		--InitCommand=cmd(shadowlength,0;zoom,0.8;x,SCREEN_CENTER_X;y,40);
		SetCommand=function(self,params)
			local Steps = GAMESTATE:GetCurrentSteps(params.Player)
			local Diff = Steps:GetDifficulty()
			local Style = Steps:GetStepsType()
			
			local idxsteps = Enum.Reverse(Difficulty)[Diff]
			local idxstyle = Enum.Reverse(StepsType)[Style]
			
			if idxsteps > oldidxsteps then
				sDir = "Right"--, next Diff"
				if idxstyle < oldidxstyle then
					sDir = "Left"--, prev Style"
				end
			elseif idxsteps < oldidxsteps then
				sDir = "Left"--, prev Diff"
				if idxstyle > oldidxstyle then
					sDir = "Right"--, next Style"
				end
			else --if idxsteps == oldidxsteps then
				if idxstyle > oldidxstyle then
					sDir = "Right"--, same Diff, next Style"
				elseif idxstyle < oldidxstyle then
					sDir = "Left"--, same Diff, prev Style"
				end
			end
			if oldidxsteps ~= idxsteps or oldidxstyle ~= idxstyle then
				MESSAGEMAN:Broadcast("PumpDifficultiesChanged", {Dir = sDir, Player = params.Player})
				--SCREENMAN:SystemMessage(string.format("Diff dir: %s\nby %s",sDir,PlayerNumberToString(params.Player)))
			end
			
			oldidxsteps = idxsteps
			oldidxstyle = idxstyle
		end;
		CurrentSongChangedMessageCommand=function(self)
			local song = GAMESTATE:GetCurrentSong() or "_"
			local idxsong = GetTableIndex(SongTitles,tostring(song))
			local iDir = idxsong - oldidxsong
			
			MESSAGEMAN:Broadcast("SongDirectionChanged",{Dir = iDir})
			--SCREENMAN:SystemMessage(string.format("Song With index: %s\niDir: %i",idxsong,iDir))
			
			oldidxsong = idxsong
			
			--local cursong = GAMESTATE:GetCurrentSong()
			--prevsong = cursong
		end;
		CurrentStepsP1ChangedMessageCommand=function(self)
			self:playcommand("Set",{Player = PLAYER_1});
		end;
		CurrentStepsP2ChangedMessageCommand=function(self)
			self:playcommand("Set",{Player = PLAYER_2});
		end;
	}
}